implementation module ppm

/*
 * This module writes images to the PPM/PGM format. It has been
 * loosely based on wrppm.c by Thomas Lane as part of the Independent
 * JPEG Group's software.
 *
 * This module has been implemented in order to provide an example
 * how to use the JPEG decoding software. Therefore it has been
 * keep plain and simple. No fancy features, and in particular,
 * support for 8-bit images only.
 */

import StdList, StdMisc, StdString
import imagePlanes

imageToPPM :: Image -> [Char]
imageToPPM image
	= case image of
		(Chunky3xN 8 (left,top,right,bottom) _)
			-> (rawPPMheader 8 (right - left) (bottom - top)) ++ (imageToCharList image [])
		(Grey 8 (left,top,right,bottom) _)
			-> (rawPGMheader 8 (right - left) (bottom - top)) ++ (imageToCharList image [])
		_
			-> abort "imageToPPM: image type not supported"
		
rawPGMheader :: Int Int Int -> [Char]
rawPGMheader precision width height
	= fromString
		("P5\n" +++
		toString width +++ " " +++ toString height +++ "\n" +++
		toString max +++ "\n")
where
	max = (1 << precision) - 1

rawPPMheader :: Int Int Int -> [Char]
rawPPMheader precision width height
	= fromString
		("P6\n" +++
		toString width +++ " " +++ toString height +++ "\n" +++
		toString max +++ "\n")
where
	max = (1 << precision) - 1
